%
% physjmithesis v1.1
% By Tabish 
% Version 1.0 released 15/09/2012
%-------------------------- identification ---------------------
%\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{physjmithesis}[2010/07/14 v1.0 physjmi thesis class]
%-------------------------- initial code -----------------------
\newif\ifCU@bookmode
\CU@bookmodetrue

\DeclareOption{report}{\CU@bookmodefalse}
\DeclareOption{book}{\CU@bookmodetrue}
\ProcessOptions\relax%

\ifCU@bookmode
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}%
\ProcessOptions\relax%
\ifx\pdfoutput\undefined%
   \LoadClass[dvips, a4paper]{book}%
\else%
   \LoadClass[pdftex, a4paper]{book}%
\fi%
\else
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}%
\ProcessOptions\relax%
\ifx\pdfoutput\undefined%
  \LoadClass[dvips, a4paper]{report}%
\else%
   \LoadClass[pdftex, a4paper]{report}%
\fi%
%\renewcommand{\refname}{References}%
\fi

%\DeclareOption{book}{%
%}%
\usepackage{setspace}
\usepackage{tocbibind}
\usepackage{amssymb}
\usepackage{amsmath}
%\usepackage{graphicx}
\usepackage{fancyhdr}
\usepackage{eucal}
\usepackage[english]{babel}
\usepackage[usenames, dvipsnames]{color}
\usepackage[perpage]{footmisc}
%\usepackage[square, sort, numbers, authoryear]{natbib}
\usepackage[scaled]{helvet}
\usepackage{ifthen}
\usepackage{ifpdf}


%Bibliography
%uncomment next line to change bibliography name to references for Book document class
%\renewcommand{\bibname}{References}
% note that this doesn't do much if you later define another bibliography style 


% Nomenclature
%\usepackage{nomencl}
%\makenomenclature
%\renewcommand\nomgroup[1]{%
%  \ifthenelse{\equal{#1}{A}}{%
%   \item[\textbf{Roman Symbols}] }{%             A - Roman
%    \ifthenelse{\equal{#1}{G}}{%
%     \item[\textbf{Greek Symbols}]}{%             G - Greek
%      \ifthenelse{\equal{#1}{R}}{%
%        \item[\textbf{Superscripts}]}{%              R - Superscripts
%          \ifthenelse{\equal{#1}{S}}{%
%           \item[\textbf{Subscripts}]}{{%             S - Subscripts
%	    \ifthenelse{\equal{#1}{X}}{%
%	     \item[\textbf{Other Symbols}]}{{%    X - Other Symbols
%	    \ifthenelse{\equal{#1}{Z}}{%
%	     \item[\textbf{Acronyms}]}%              Z - Acronyms
%              			{{}}}}}}}}}}
%
\ifpdf
%-->
%--> Google.com search "hyperref options"
%--> 
%--> http://www.ai.mit.edu/lab/sysadmin/latex/documentation/latex/hyperref/manual.pdf
%--> http://www.chemie.unibas.ch/~vogtp/LaTeX2PDFLaTeX.pdf 
%--> http://www.uni-giessen.de/partosch/eurotex99/ oberdiek/print/sli4a4col.pdf
%--> http://me.in-berlin.de/~miwie/tex-refs/html/latex-packages.html
%-->
    \usepackage[ pdftex, plainpages = false, pdfpagelabels, 
                 pdfpagelayout = OneColumn, % display single page, advancing flips the page - Sasa Tomic
                 bookmarks,
                 bookmarksopen = true,
                 bookmarksnumbered = true,
                 breaklinks = true,
                 linktocpage,
%                 pagebackref,
                 colorlinks = true,
                 linkcolor = blue,
                 urlcolor  = blue,
                 citecolor = red,
                 anchorcolor = green,
                 hyperindex = true,
                 hyperfigures
                 ]{hyperref} 
    \usepackage[pdftex]{graphicx}
    \DeclareGraphicsExtensions{.png, .jpg, .pdf}

    \pdfcompresslevel=9
    \graphicspath{{ThesisFigs/PNG/}{ThesisFigs/PDF/}{ThesisFigs/}}
\else
    \usepackage[ dvips, 
                 bookmarks,
                 bookmarksopen = true,
                 bookmarksnumbered = true,
                 breaklinks = true,
                 linktocpage,
                 pagebackref,
                 colorlinks = true,
                 linkcolor = blue,
                 urlcolor  = blue,
                 citecolor = red,
                 anchorcolor = green,
                 hyperindex = true,
                 hyperfigures
                 ]{hyperref}

    %\usepackage{epsfig}
    \usepackage{graphicx}

    \DeclareGraphicsExtensions{.eps, .ps}
    \graphicspath{{ThesisFigs/EPS/}{ThesisFigs/}}
\fi

%define the page size including an offset for binding
%\setlength{\topmargin}{0.0in}
%\setlength{\oddsidemargin}{0in}
%\setlength{\evensidemargin}{0in}
%\setlength{\textheight}{700pt}
%\setlength{\textwidth}{500pt}


%A4 settings
\ifpdf
   \pdfpageheight=297mm
   \pdfpagewidth=210mm
\else
   \setlength{\paperheight}{297mm}
   \setlength{\paperwidth}{210mm}
\fi

\setlength{\hoffset}{0.00cm}
\setlength{\voffset}{0.00cm}

\setlength{\evensidemargin}{1.96cm}
%\setlength{\oddsidemargin}{-0.54cm}
\setlength{\topmargin}{-10mm}
\setlength{\headheight}{1.36cm}
\setlength{\headsep}{1.00cm}
\setlength{\textheight}{22.00cm}
\setlength{\textwidth}{15.0cm}
\setlength{\marginparsep}{1mm}
\setlength{\marginparwidth}{3cm}
\setlength{\footskip}{2.36cm}

\pagestyle{fancy}
\renewcommand{\chaptermark}[1]{\markboth{\MakeUppercase{\thechapter. #1 }}{}}
\renewcommand{\sectionmark}[1]{}
\newcommand{\chapterhead}[1]{\markboth{}{\MakeUppercase{\thechapter. #1}}}
\fancyhf{}
\fancyhead[RO]{\bfseries\rightmark}
\fancyhead[LE]{\bfseries\leftmark}
\fancyfoot[C]{\thepage}
\renewcommand{\headrulewidth}{0.5pt}
\renewcommand{\footrulewidth}{0pt}
\addtolength{\headheight}{0.5pt}
\fancypagestyle{plain}{
  \fancyhead{}
  \renewcommand{\headrulewidth}{0pt}
}

\newcommand{\submittedtext}{{A thesis submitted for the degree of}}
%
%
% DECLARATIONS
%
% These macros are used to declare arguments needed for the
% construction of the title page and other preamble.

% The year and term the degree will be officially conferred
\def\degreedate#1{\gdef\@degreedate{#1}}
% The full (unabbreviated) name of the degree
\def\degree#1{\gdef\@degree{#1}}
% The name of your college or department(eg. Trinity, Pembroke, Maths, Physics)
\def\collegeordept#1{\gdef\@collegeordept{#1}}
% The name of your University
\def\university#1{\gdef\@university{#1}}
% Defining the crest
\def\crest#1{\gdef\@crest{#1}}
% Defining Guide
\def\guide#1{\gdef\@guide{#1}}
% Defining Co-Guide
\def\coguide#1{\gdef\@coguide{#1}}
\def\guideinstt#1{\gdef\@guideinstt{#1}}
\def\coguideinstt#1{\gdef\@coguideinstt{#1}}
% Defining Head
\def\hod#1{\gdef\@hod{#1}}
\def\hodposition#1{\gdef\@hodposition{#1}}
% Defining submission month year
\def\submissiondate#1{\gdef\@submissiondate{#1}}

% These macros define an environment for front matter that is always 
% single column even in a double-column document.

\newenvironment{alwayssingle}{%
       \@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
       \else\newpage\fi}
       {\if@restonecol\twocolumn\else\newpage\fi}

%define title page layout
\renewcommand{\maketitle}{%
\pagenumbering{roman} % Sasa Tomic
\setcounter{page}{0}  % Sasa Tomic

%% Cover Page
\begin{alwayssingle}
    \renewcommand{\footnotesize}{\small}
    \renewcommand{\footnoterule}{\relax}
    \thispagestyle{empty}
%  \null\vfill
\begin{center}
{\large \vspace*{5mm} {{\@crest} \par} \vspace*{20mm}}
    { \Large {\bfseries\MakeUppercase {\@title}} \par}
\vspace*{20mm}
{\large {\bf Ph.D. Thesis}\par}
\vspace*{2ex}
{\large {\bf by}\par}
\vspace*{6ex}
    {{\Large\bf \@author} \par}
\vspace*{1ex}
    {{\large\bf \@collegeordept} \par}
\vfill
    {{\Large\bf\@university} \par}
\vspace*{1mm}
    {\Large\bf New Delhi} \\
\vspace*{4mm}
    {\Large\bf \@submissiondate}
\end{center}
\end{alwayssingle}
\newpage

\setcounter{page}{0}  % Sasa Tomic
\begin{alwayssingle}
    \renewcommand{\footnotesize}{\small}
    \renewcommand{\footnoterule}{\relax}
    \thispagestyle{empty}
%  \null\vfill
\begin{center}
    { \LARGE {\bfseries {\@title}} \par}
\vspace*{10mm}
{\large {\bfseries Thesis}\par}
{\large {\bfseries submitted to}\par}
    {\large {\@university} \par}
{\large \vspace*{10mm} {{\@crest} \par} \vspace*{5mm}}
{\large in partial fulfillment of the requirements of the award of the \par}
\vspace*{1ex}
    {\large Degree of \it {\@degree} \par}
\vspace*{1ex}
{\large {Physics}\par}
{\large {by}\par}
\vspace*{1ex}
    {{\Large \@author} \par}
{\large \vspace*{2ex}}
{\large under the supervision of \par}
\vspace*{5ex}
\vspace*{5ex}
\ifcoguide
\begin{tabular}{c p{3cm} c }
 \@guide                            & &  \@coguide \\
 (Supervisor)                       & &  (Co-supervisor) \\
 \@guideinstt                       & &  \@coguideinstt  \\
\end{tabular}
\else
 \@guide  \\
 \@collegeordept \\
 \@university \par
\fi
\vfill
    {{\bf\@collegeordept} \par}
\vspace*{1mm}
    {{\bf\@university} \par}
\vspace*{1mm}
    {\bf New Delhi}
\end{center}
\end{alwayssingle}

\newpage
\thispagestyle{empty}
\centerline{\Large{\bf DECLARATION}}
\vspace{2cm}
\onehalfspacing
\noindent
I, {\bf \@author}, student of Ph.D. hereby declare that 
the thesis titled {\bf ``\@title"} which is submitted by me to the
\@collegeordept, \@university, New Delhi in partial
fulfilment of the requirement for the award of the degree of Doctor
of Philosophy has not previously formed the basis for the award of
any Degree, Diploma, Associateship, Fellowship or other similar title or
recognition. This is to declare further that I have also fulfilled the
requirements of Para 8 (viii and ix) of the Ph.D. Ordinance.

\vskip 2.5cm
\noindent New Delhi\\                     
Date:
\hfill              {\bf $\big ($\@author $\big )$}
\hspace*{110mm}

\newpage

\vspace{6cm}
\centerline{\large \bf CERTIFICATE}
\vspace{2cm}
\onehalfspacing
\noindent
\thispagestyle{empty}
On the basis of declaration submitted by {\bf \@author}, student of
Ph.D., I hereby certify that the thesis titled {\bf ``\@title"} which is
submitted to the \@collegeordept, \@university,
New Delhi in partial fulfilment of the requirement for the award of the
degree of Doctor of Philosophy, is an original contribution with existing
knowledge and faithful record of research carried out by him/her under
my guidance and supervision. To the best of my knowledge this work has
not been submitted in part or full for any Degree or Diploma
to this University or elsewhere.
\vskip 3.0cm
\begin{tabular}{p{8cm} p{8cm}}
{\bf (\@guide)}\par
Supervisor\par
\@guideinstt\par \vskip 2mm
New Delhi\par                     
Date:  &
%{\bf (\@coguide)}\par
%Co-Supervisor\par
%\@coguideinstt
\end{tabular}



\vspace{3.0cm}                        
\centerline{{\bf \@hod}}
\centerline{\@hodposition}
\centerline{\@collegeordept}
\centerline{\@university, New Delhi}

}

% DEDICATION
%
% The dedication environment makes sure the dedication gets its
% own page and is set out in verse format.

\newenvironment{dedication}
{\begin{alwayssingle}
  \pagestyle{empty}
  \begin{center}
  \vspace*{1.5cm}
  {\LARGE }
  \end{center}
  \vspace{0.5cm}
  \begin{quote} \begin{center}}
{\end{center} \end{quote} \end{alwayssingle}}


% ACKNOWLEDGEMENTS
%
% The acknowledgements environment puts a large, bold, centered 
% "Acknowledgements" label at the top of the page. The acknowledgements
% themselves appear in a quote environment, i.e. tabbed in at both sides, and
% on its own page.

\newenvironment{acknowledgements}
{\pagestyle{empty}
\begin{alwayssingle}
\begin{center}
\vspace*{1.5cm}
{\Large \bfseries Acknowledgements}
\end{center}
\vspace{0.5cm}
\begin{quote}}
{\end{quote}\end{alwayssingle}}

% The acknowledgementslong environment puts a large, bold, centered 
% "Acknowledgements" label at the top of the page. The acknowledgement itself 
% does not appears in a quote environment so you can get more in.

\newenvironment{acknowledgementslong}
{\pagestyle{empty}
\begin{alwayssingle}
\begin{center}
\vspace*{1.5cm}
{\Large \bfseries Acknowledgements}
\end{center}
\vspace{0.5cm}\begin{quote}}
{\end{quote}\end{alwayssingle}}

%ABSTRACT
%
%The abstract environment puts a large, bold, centered "Abstract" label at
%the top of the page. The abstract itself appears in a quote environment,
%i.e. tabbed in at both sides, and on its own page.

\newenvironment{abstracts} {\begin{alwayssingle} \pagestyle{empty}
  \begin{center}
  \vspace*{1.0cm}
  {\Large \bfseries  Abstract}
  \end{center}
  \vspace{0.5cm}
   \begin{quote}}
{\end{quote}\end{alwayssingle}}

%The abstractlong environment puts a large, bold, centered "Abstract" label at
%the top of the page. The abstract itself does not appears in a quote
%environment so you can get more in.

\newenvironment{abstractslong} {\begin{alwayssingle} \pagestyle{empty}
  \begin{center}
  \vspace*{1.0cm}
  {\Large \bfseries  Abstract}
  \end{center}
  \vspace{0.5cm} \begin{quote}}
{\end{quote}\end{alwayssingle}}

%The abstractseparate environment is for running of a page with the abstract
%on including title and author etc as required to be handed in separately

\newenvironment{abstractseparate} {\begin{alwayssingle} \pagestyle{empty}
  \vspace*{-1in}
 \begin{center}
    { \Large {\bfseries {\@title}} \par}
    {{\large \vspace*{1ex} \@author} \par}
{\large \vspace*{1ex}
    {{\@collegeordept} \par}
    {{\@university} \par}
\vspace*{1ex}
    {{\it \submittedtext} \par}
    {\it {\@degree} \par}
\vspace*{2ex}
    {\@degreedate}}
  \end{center}}
{\end{alwayssingle}}

%ROMANPAGES
%
% The romanpages environment set the page numbering to lowercase roman one
% for the contents and figures lists. It also resets
% page-numbering for the remainder of the dissertation (arabic, starting at 1).

\newenvironment{romanpages}
{\setcounter{page}{1}
  \renewcommand{\thepage}{\roman{page}}}
{\newpage\renewcommand{\thepage}{\arabic{page}}}
%{\newpage\renewcommand{\thepage}{\arabic{page}}\setcounter{page}{1}}

